n       = 200;  % Number of cells
k0      = 1;    % Wavenumber
a       = 0.02; % Radius
L       = 3.0;  % Length
h       = L/n;  % Cell size

% Z-coordinate for starting and ending points of the segments
zs      = zeros(1,n); 
ze      = zeros(1,n); 
zs(1:n) = linspace(-L/2, L/2-h, n);
ze      = zs + h;
E0      = ones(1,n);

% Solve Hallen's equation
[Iz, C, Imi] = EFIE(zs, ze, E0, a, k0);

% Plot the results
figure(1), clf
plot([zs(1) zs(1:end-1)+h/2 ze(end)], ...
     [0 real(Iz) 0], 'k-'), hold on
plot([zs(1) zs(1:end-1)+h/2 ze(end)], ...
     [0 imag(Iz) 0], 'k--')
xlabel('z [m]'), ylabel('I [A]')
